//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#define def_NameObj     "Demo"
#define def_KEY_UP      38
#define def_KEY_DOWN    40
//+------------------------------------------------------------------+
int OnInit()
{
   ObjectCreate(0, def_NameObj, OBJ_VLINE, 0, 0, 0);
   ObjectSetInteger(0, def_NameObj, OBJPROP_COLOR, clrRoyalBlue);
   ObjectCreate(0, def_NameObj, OBJ_HLINE, 0, 0, 0);
   ObjectSetInteger(0, def_NameObj, OBJPROP_COLOR, clrPurple);

   return INIT_SUCCEEDED;
};
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
   return rates_total;
};
//+------------------------------------------------------------------+
void OnChartEvent(const int id, const long &lparam, const double &dparam, const string &sparam)
{
   static int p = 0;
   MqlRates rate[1];

   switch(id)
   {
      case CHARTEVENT_KEYDOWN:
         switch ((int)lparam)
         {
            case def_KEY_DOWN:
               p = (p < Bars(_Symbol, _Period) ? p + 1 : p);
               break;
            case def_KEY_UP:
               p = (p > 0 ? p - 1 : p);
               break;
            default:
               return;
         }
         Comment(StringFormat("Current bar analyzed: %d", p));
         CopyRates(_Symbol, _Period, p, rate.Size(), rate);
         ObjectMove(0, def_NameObj, 0, rate[0].time, rate[0].close);
         ObjectMove(0, def_NameObj, 0, rate[0].time, rate[0].close);
         break;
   }
   ChartRedraw();
};
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
   Comment("");
   ObjectDelete(0, def_NameObj);
   ChartRedraw();
};
//+------------------------------------------------------------------+